-------------------------------------------------
function inRange(id, target)
calls.enter("inRange",id)
	local dist = service.person2person_distance(id, target)
	local res = isDefWeaponRanged(id, dist)
	
	if (res == true) then
		log(id, "Target:", target, "is in range",dist)
	else
		log(id, "Target:", target, "is out of range",dist)
	end
calls.leave("inRange",id)	
	return res
end
-------------------------------------------------
function addLoot(id, body, slot)
calls.enter("addLoot",id)
	log(id, "AI    :    ", body)
	addTakeItem(id, body, slot)
	Humans[id].lastMoveCommand = nil
calls.leave("addLoot",id)
end
-------------------------------------------------
function addLookPrim(id, x, y, z,mistake)
calls.enter("addLookPrim",id)
	local ret = false
	local ox, oy, oz = getPersonOrientation(id)
	if(mistake==nil) then
		mistake = 5
	end
	local x1, y1, z1, f1 = getPosition(id)
	local dist = service.person2point_distance(id,x, y, z)

	if((z-z1)/dist>0.5) then	-- max 30 grad
		log(id,"*** correct z to normal head rotate",(z-z1)/dist)
		z = dist/2+z1
	end

	local perAngle = math.deg(math.atan2(oy, ox))
	local targetAngle = math.deg(math.atan2(y - y1,x - x1))
	local delta = math.abs(perAngle-targetAngle)
	if(delta < 0) then
		delta = delta + 360
	end
	if (delta >= 360) then
		delta = delta - 360
	end
	if (delta >= 180) then
		delta = 360 - delta
	end
	log(id,"Angle between: ",delta)

	if(delta>mistake) then
		log(id, "AI    : addLook (id="..id..", x="..x..", y="..y..", z="..z..")")
		addLook(id, x, y, z)
		Humans[id].lastMoveCommand = nil
		ret = true
	else
		log(id, "Try addLook... Already rotated")
	end
calls.leave("addLookPrim",id)
	return(ret)
end
-------------------------------------------------
function addRotate(id, x, y, z, mistake)
calls.enter("addRotate",id)
	--     ,
	--         ,     ,
	--     
	if (getPersonPose(id) == "stand") then
		z = z + 1.75
	elseif (getPersonPose(id) == "sit") then
		z = z + 1
	elseif (getPersonPose(id) == "lie") then
		z = z + 0.2
	else
		log(id, "Unknown pose", getPersonPose(id))
	end
	local ret = addLookPrim(id, x, y, z, mistake)
calls.leave("addRotate",id)
	return(ret)
end
-------------------------------------------------
function addPose(id, pose)
calls.enter("addPose",id)
	local ret = false
	--      - :    ?
	--    -  
	if (getPersonPose(id) ~= pose) then
		log(id, "AI    : addPose (id=",id,"pose=",pose,")")
		Humans[id].lastMoveCommand = nil
		addPoseEx(id, pose)
		ret = true
	end
calls.leave("addPose",id)
	return(ret)
end
-------------------------------------------------
function addReload(id, slot, barrel)
calls.enter("addReload",id)
	log(id, "AI    : addReloadWeapon (id=",id,")")
	local bar = barrel

	if (barrel == 2) then
		bar = "secondary"
	else
		bar = "primary"
	end

	Humans[id].lastMoveCommand = nil
	addReloadWeapon(id, slot, bar)
calls.leave("addReload",id)
end
-------------------------------------------------
function poseDown(id)
calls.enter("poseDown",id)
	--   
	local ret = false
	if (getPersonPose(id) == "stand") then
		log(id, "AI    : addPose (id=",id,"pose=sit)")
		Humans[id].lastMoveCommand = nil
		addPoseEx(id, "sit")
		ret = true
	elseif (getPersonPose(id) == "sit") then
		log(id, "AI    : addPose (id=",id,"pose=lie)")
		Humans[id].lastMoveCommand = nil
		addPoseEx(id, "lie")
		ret = true
	end
calls.leave("poseDown",id)
	return(ret)
end
-------------------------------------------------
function poseUp(id)
calls.enter("poseUp",id)
	--   
	local ret = false
	if (getPersonPose(id) == "lie") then
		log(id, "AI    : addPose (id=",id,"pose=sit)")
		addPoseEx(id, "sit")
		Humans[id].lastMoveCommand = nil
		ret = true
	elseif (getPersonPose(id) == "sit") then
		log(id, "AI    : addPose (id=",id,"pose=stand)")
		addPoseEx(id, "stand")
		Humans[id].lastMoveCommand = nil
		ret = true
	end
calls.leave("poseUp",id)
	return(ret)
end
-------------------------------------------------
function addStrafe(id, side, dist)
calls.enter("addStrafe",id)
	local x, y, z, f = service.randomSidePoint(id, side, dist)
	local px,py,pz,pf = getPosition(id)
	x,y = service.checkPointForBorders( px, py, x, y )
	log(id, "AI    : addStrafe (id=",id,"side=",side,"dist=",dist,")")
	addMoveEx(id, "strafe", x, y, z, f)
calls.leave("addStrafe",id)
end
-------------------------------------------------
function executeOrders(id)
calls.enter("executeOrders",id)
	local x,y,z,f = getPosition(id)
	Humans[id].orders = 0
	Humans[id].freeze = 0
	log(id, "  ")
	execOrders(id)
calls.leave("executeOrders",id)
end
-------------------------------------------------
function attackTarget(id, target, aim)
calls.enter("attackTarget",id)
	local x, y, z, f = getPosition(target)
	addRotate(id, x, y, z)
	log(id, "  : ",target,"aim:", aim)
	addShootToEnemyEx(id, target, aim)
	Humans[id].lastMoveCommand = nil
calls.leave("attackTarget",id)
end
-------------------------------------------------
function meleeAttack(id, target)
calls.enter("meleeAttack",id)
	if (getPersonPose(id) ~= "stand") then
		log(id, "AI    : addPose (id=",id,"pose=stand)")
		addPoseEx(id, "stand")
	end
	local dist = service.person2person_distance(id, target)
	log(id, "    :",target,dist)
	addFight(id, target)
	Humans[id].lastMoveCommand = nil
calls.leave("meleeAttack",id)
end
-------------------------------------------------
function attackLocation(id, x, y, z, mistake)
calls.enter("attackLocation",id)
	addLookPrim(id, x, y, z)
	if(mistake==nil) then
		mistake = 0
	end
	log(id, "  .",mistake)
	addShootToPointEx(id, 
		x+service.getRealRand(-mistake,mistake), 
		y+service.getRealRand(-mistake,mistake), z, 0)
	Humans[id].lastMoveCommand = nil
calls.leave("attackLocation",id)
end
-------------------------------------------------
function attackGrenade(id, target, mistake)
calls.enter("attackGrenade",id)
	local x, y, z, f = getPosition(target)
	addLookPrim(id, x, y, z)
	if(mistake==nil) then
		mistake = 0
	end
	local x1,y1,z1,f1 = getPosition(id)
	if(f1<f) then
		z = z+0
	else
		z = z-1
	end

	log(id, "  .",mistake)
	addShootToPointEx(id, 
		x+service.getRealRand(-mistake,mistake), 
		y+service.getRealRand(-mistake,mistake), z, 0)
	Humans[id].lastMoveCommand = nil
calls.leave("attackGrenade",id)
end
-------------------------------------------------
function stop(id)
calls.enter("stop",id)
	Humans[id].orders = 0
	log(id, " !!!")
	Humans[id].busy = 0
	Humans[id].strategy = 0
	Humans[id].turnDone = false
	clearOrders(id)
	removeCommands(id)
	Humans[id].lastMoveCommand = nil
calls.leave("stop",id)
end
-------------------------------------------------
function endOfTurn(id)
calls.enter("endOfTurn",id)
	Humans[id].busy = 0
	Humans[id].strategy = 0
	Humans[id].priority = 0
	if(Humans[id].leaderTurnsForSkip==nil) then
		Humans[id].leaderTurnsForSkip = 0
	else
		Humans[id].leaderTurnsForSkip = Humans[id].leaderTurnsForSkip - 1
	end
	if(Humans[id].surroundTurnsForSkip==nil) then
		Humans[id].surroundTurnsForSkip = 0
	else
		Humans[id].surroundTurnsForSkip = Humans[id].surroundTurnsForSkip - 1
	end
	Humans[id].lastMoveCommand = nil
	Humans[id].turnDone = false
	memory.resortLastSeen(id)
	removeCommands(id)
	log(id, " ", takeAP(id),Humans[id].leaderTurnsForSkip,Humans[id].surroundTurnsForSkip)
calls.leave("endOfTurn",id)
	endTurn(id)
end
-------------------------------------------------
function estimateAP(id)
calls.enter("estimateAP",id)
	log(id, " AP")
	startCalcAP(id)
calls.leave("estimateAP",id)
end
-------------------------------------------------
function clearAllOrders(id)
calls.enter("clearAllOrders",id)
	log(id, "  ")
	removeCommands(id)
calls.leave("clearAllOrders",id)
end
-------------------------------------------------
function addSmartMove(id, smartmode, x, y, z, f)
calls.enter("addSmartMove",id)
	--        ,      
	--       
	--    
	local mode = "move"
	local dist = service.person2point_distance(id, x, y, z)

        if(f==nil) then
        	log(id,"***** addSmartMove:INVALID FLOOR passed")
		f = 1
	end

	if (smartmode == "run") then
		mode = "run"
		if (getPersonPose(id) ~= "stand") then
			log(id, "AI    : addPose (id=",id,"pose=stand)")
			addPoseEx(id, "stand")
		end
	elseif (smartmode == "walk") then
		if (getPersonPose(id) ~= "stand") then
			log(id, "AI    : addPose (id=",id,"pose=stand)")
			addPoseEx(id, "stand")
		end
	elseif (smartmode == "sneak") then
		if (getPersonPose(id) ~= "sit") then
			log(id, "AI    : addPose (id=",id,"pose=sit)")
			addPoseEx(id, "sit")
		end
	elseif (smartmode == "crawl") then
		if (getPersonPose(id) ~= "lie") then
			log(id, "AI    : addPose (id=",id,"pose=lie)")
			addPoseEx(id, "lie")
		end
	elseif (smartmode == "move") then
		log(id, "     -      addMove")
	else
		log(id, "    -    ")
	end

	local x1,y1,z1,f1 = getPosition(id)
	log(id, "AI    : addMove (id=",id,"mode=",mode,"x=",x,"y=",y,"z=",z,"f=",f,"distance=",dist,")")
	addMoveEx(id, mode, x, y, z, f)
	if((f1~=f) 
--		and (not isGameInRT())
		) then
		Humans[id].lastMoveCommand = {}
		Humans[id].lastMoveCommand.mode = smartmode
		Humans[id].lastMoveCommand.x = x
		Humans[id].lastMoveCommand.y = y
		Humans[id].lastMoveCommand.z = z
		Humans[id].lastMoveCommand.f = f1
	end
calls.leave("addSmartMove",id)
end

